<?php
require(dirname(__DIR__) . '/../../wp-load.php');


$inputJSON = file_get_contents('php://input');
if (!empty($inputJSON)) {
    $input = json_decode($inputJSON, true);
    if (json_last_error() === JSON_ERROR_NONE) {
        $_POST = $input;
    }
}

$function = isset($_POST['function']) ? sanitize_text_field($_POST['function']) : '';
$apiToken = get_option('rapid_token');


switch ($function) {

// =======================
// SOLICITAR SERVICIOS
// =======================
    case "solicitarServiciosRapid":
        $data = ["apiKey" => $apiToken];
        $data_string = json_encode($data, JSON_UNESCAPED_UNICODE);

        $curl = curl_init("https://portal.rapidexpress.es/api/servicios.php");
        curl_setopt_array($curl, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST  => "POST",
            CURLOPT_POSTFIELDS     => ["data" => $data_string],
            CURLOPT_HTTPHEADER     => ["cache-control: no-cache"],
        ]);
        $response = curl_exec($curl);
        curl_close($curl);

        echo $response;
        exit;

// =======================
// GENERAR ENVÍO
// =======================
case "generarEnvioRapid":
    $producto = isset($_POST["producto"]) ? sanitize_text_field($_POST["producto"]) : '';
    $orderId  = isset($_POST["orderId"]) ? intval($_POST["orderId"]) : 0;
    $raw_destino  = isset($_POST["destino"])  ? $_POST["destino"]  : [];
    $raw_recogida = isset($_POST["recogida"]) ? $_POST["recogida"] : [];

    $destino  = is_array($raw_destino)  ? $raw_destino  : json_decode(stripslashes($raw_destino),  true);
    $recogida = is_array($raw_recogida) ? $raw_recogida : json_decode(stripslashes($raw_recogida), true);

    if (!is_array($destino) || !is_array($recogida)) {
        wp_send_json(['result'=>0,'error'=>'Parámetros mal formados'], 200);
    }
    if (!empty($destino['pais']) && strpos($destino['pais'], ':') !== false) {
        $destino['pais'] = explode(':', $destino['pais'])[0];
    }
    if (!empty($recogida['pais']) && strpos($recogida['pais'], ':') !== false) {
        $recogida['pais'] = explode(':', $recogida['pais'])[0];
    }
    $destino['tipo'] = isset($destino['tipo']) && strtoupper($destino['tipo']) === 'DOC' ? 'DOC' : 'PAQ';
    unset($recogida['tipo']);
    $defaults = [
        'kilos'            => '0.1',
        'bultos'           => '1',
        'referencia'       => '',
        'observaciones'    => '',
        'valor_asegurado'  => '0',
        'valor_reembolso'  => '0',
    ];
    foreach ($defaults as $k=>$v) {
        if (!isset($destino[$k]) || $destino[$k]==='') $destino[$k] = $v;
        $destino[$k] = (string)$destino[$k];
    }
    $data = [
        "apiKey"   => $apiToken,
        "producto" => (string)$producto,
        "destino"  => $destino,
        "recogida" => $recogida
    ];
    $data_string = json_encode($data, JSON_UNESCAPED_UNICODE);
    $ch = curl_init("https://portal.rapidexpress.es/api/solicitarEnvio.php");
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT        => 30,
        CURLOPT_POST           => true,
        CURLOPT_POSTFIELDS     => http_build_query(['data' => $data_string]),
        CURLOPT_HTTPHEADER     => ['cache-control: no-cache'],
    ]);
    $response = curl_exec($ch);
    $err      = curl_error($ch);
    curl_close($ch);
    if ($err) {
        wp_send_json(['result'=>0, 'error'=>"cURL: $err"], 200);
    }
    if (trim($response) === 'incorrect data') {
        wp_send_json(['result'=>0, 'error'=>'incorrect data'], 200);
    }
    $api = json_decode($response, true);
    if (!$api) {
        wp_send_json(['result'=>0, 'error'=>'Respuesta no JSON de RapidExpress', 'raw'=>$response], 200);
    }
    if (isset($api['result']) && (string)$api['result'] === '200' && !empty($api['pedido']) && !empty($api['albaran'])) {
        update_post_meta($orderId, 'rapid_envio', sanitize_text_field($api['pedido']));
        update_post_meta($orderId, 'rapid_albaran', sanitize_text_field($api['albaran']));
        wp_send_json([
            'result'  => 200,
            'pedido'  => $api['pedido'],
            'albaran' => $api['albaran']
        ], 200);
    }
    wp_send_json(['result'=>0, 'error'=>$api], 200);

// =======================
// OBTENER ALBARÁN
// =======================
case "obtenerAlbaran":
    $orderId = isset($_POST['orderId']) ? intval($_POST['orderId']) : 0;
    $order   = wc_get_order($orderId);
    if (!$order) {
        wp_send_json(['result'=>0,'error'=>'Pedido no encontrado'], 200);
    }
    $envio = (string)$order->get_meta('rapid_envio');
    if ($envio === '') {
        wp_send_json(['result'=>0,'error'=>'El pedido no tiene nº de envío RapidExpress'], 200);
    }
    $payload = json_encode(["apiKey"=>$apiToken, "envio"=>$envio], JSON_UNESCAPED_UNICODE);
    $ch = curl_init("https://portal.rapidexpress.es/api/obtenerAlbaran.php");
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT        => 30,
        CURLOPT_POST           => true,
        CURLOPT_POSTFIELDS     => http_build_query(['data'=>$payload]),
        CURLOPT_HTTPHEADER     => ['cache-control: no-cache'],
    ]);
    $response = curl_exec($ch);
    $err      = curl_error($ch);
    curl_close($ch);
    if ($err) {
        wp_send_json(['result'=>0,'error'=>"cURL: $err"], 200);
    }
    $api = json_decode($response, true);
    if (!$api || empty($api['albaran']) || ($api['formato'] ?? '') !== 'PDF') {
        wp_send_json(['result'=>0,'error'=>$api ?: 'Respuesta no válida'], 200);
    }
    $dir = plugin_dir_path(__FILE__).'albaranes/';
    if (!is_dir($dir)) { wp_mkdir_p($dir); }
    $hash = md5($envio);
    $file = $dir.$hash.'.pdf';
    file_put_contents($file, base64_decode($api['albaran']));
    echo $hash;
    exit;

// =======================
// FUNCIÓN DESCONOCIDA
// =======================
default:
    echo json_encode(["result" => 400, "error" => "Función no reconocida o no enviada."]);
    exit;
}
