<?php
/*
Plugin Name: RapidExpress WooCommerce
Plugin URI: https://plat-on.es
Description: Integración de RapidExpress con WooCommerce para gestionar envíos y albaranes.
Version: 1.9
Author: Plat-on
Author URI: https://plat-on.es
License: GPL2
*/

if (!defined('ABSPATH')) exit;

class Rapidexpress_Plugin {

    public function __construct() {
        add_action('admin_menu', array($this, 'create_plugin_settings_page'));
        add_action('admin_init', array($this, 'setup_sections'));
        add_action('admin_init', array($this, 'setup_fields'));
        add_action('add_meta_boxes', array($this, 'add_meta_boxesws'));
        add_action('admin_enqueue_scripts', array($this, 'enqueue_admin_scripts'));
    }

    public function create_plugin_settings_page() {
        add_menu_page(
            'Configuración RapidExpress',
            'RapidExpress',
            'manage_options',
            'rapidexpress_settings',
            array($this, 'plugin_settings_page_content'),
            'dashicons-admin-site'
        );
    }
    public function plugin_settings_page_content() { ?>
        <div class="wrap">
            <h1>Configuración RapidExpress</h1>
            <form method="post" action="options.php">
                <?php
                settings_fields('rapidexpress_settings_group');
                do_settings_sections('rapidexpress_settings');
                submit_button();
                ?>
            </form>
        </div>
    <?php }
    public function setup_sections() {
        add_settings_section('rapidexpress_section', 'Credenciales API', null, 'rapidexpress_settings');
    }
    public function setup_fields() {
        add_settings_field(
            'rapid_token',
            'API Token',
            array($this, 'field_callback'),
            'rapidexpress_settings',
            'rapidexpress_section',
            array('label_for' => 'rapid_token')
        );
        register_setting('rapidexpress_settings_group', 'rapid_token');
    }
    public function field_callback($args) {
        $value = get_option('rapid_token', '');
        echo '<input type="text" id="'.esc_attr($args['label_for']).'" name="'.esc_attr($args['label_for']).'" value="'.esc_attr($value).'" style="width:420px" />';
    }
    public function add_meta_boxesws() {
        add_meta_box(
            'rapidexpress_metabox',
            'RapidExpress',
            array($this, 'custom_metabox_content'),
            'shop_order',
            'normal',
            'default'
        );
    }
    public function custom_metabox_content($post) {
        if (!function_exists('wc_get_order')) {
            echo '<p>WooCommerce no está activo.</p>';
            return;
        }
        $order_id = $post instanceof WP_Post ? $post->ID : (is_numeric($post) ? intval($post) : 0);
        $order    = wc_get_order($order_id);
        if (!$order) {
            echo '<p>No se pudo cargar el pedido.</p>';
            return;
        }
        $shipping = $order->get_address('shipping');
        $billing  = $order->get_address('billing');
        $addr     = (!empty($shipping['first_name']) || !empty($shipping['address_1'])) ? $shipping : $billing;
        $dest_nombre   = trim(($addr['first_name'] ?? '').' '.($addr['last_name'] ?? ''));
        $dest_direccion= trim(($addr['address_1'] ?? '').' '.($addr['address_2'] ?? ''));
        $dest_cp       = $addr['postcode'] ?? '';
        $dest_ciudad   = $addr['city'] ?? '';
        $dest_pais     = $addr['country'] ?? '';
        $dest_tel      = $addr['phone'] ?? ($billing['phone'] ?? '');
        $dest_mail     = $addr['email'] ?? ($billing['email'] ?? $order->get_billing_email());
        $total_weight = 0.0;
        foreach ($order->get_items() as $item) {
            $product = $item->get_product();
            if ($product) {
                $w = (float) $product->get_weight();
                $q = (int) $item->get_quantity();
                $total_weight += $w * $q;
            }
        }
        if ($total_weight <= 0) $total_weight = 0.1;
        $rapid_envio   = get_post_meta($order_id, 'rapid_envio', true);
        $rapid_albaran = get_post_meta($order_id, 'rapid_albaran', true);
        $store_addr  = get_option('woocommerce_store_address', '');
        $store_city  = get_option('woocommerce_store_city', '');
        $store_cp    = get_option('woocommerce_store_postcode', '');
        $store_raw   = get_option('woocommerce_default_country', 'ES'); // ES o ES:M
        $store_pais  = explode(':', $store_raw)[0]; // "ES"
        $admin_email = get_option('admin_email', get_bloginfo('admin_email'));
        $store_tel = get_option('woocommerce_pos_store_phone','');
        ?>
        <div id="rapidexpress-box">
            <p><strong>Pedido:</strong> <?php echo esc_html($order_id); ?></p>
            <p><label for="rapid_producto"><strong>Servicio:</strong></label><br/>
                <select id="rapid_producto" style="min-width:260px" <?php echo !empty($rapid_envio) ? 'disabled' : ''; ?>>
                    <option>Cargando servicios...</option>
                </select>
            </p>
            <?php if (empty($rapid_envio)): ?>
                <button id="rapid_generar_envio" class="button button-primary">Petición de recogida</button>
            <?php else: ?>
                <p>
                    <strong>Nº Envío:</strong> <?php echo esc_html($rapid_envio); ?><br/>
                    <strong>Albarán:</strong> <?php echo esc_html($rapid_albaran); ?>
                </p>
                <button id="obtenerAlbaran" class="button">Descargar Albarán</button>
            <?php endif; ?>
            <div id="rapid_resultado" style="margin-top:10px;color:#0073aa;"></div>
        </div>
<script type="text/javascript">
jQuery(function($){
  const ajaxURL  = "<?php echo esc_js(plugins_url('functions.php', __FILE__)); ?>";
  const orderId  = "<?php echo esc_js($order_id); ?>";
  const destinoPrefill = {
    nombre: <?php echo json_encode($dest_nombre ?: ''); ?>,
    contacto: <?php echo json_encode($dest_nombre ?: ''); ?>,
    direccion: <?php echo json_encode($dest_direccion ?: ''); ?>,
    cp: <?php echo json_encode($dest_cp ?: ''); ?>,
    ciudad: <?php echo json_encode($dest_ciudad ?: ''); ?>,
    pais: <?php echo json_encode($dest_pais ?: 'ES'); ?>,
    telefono: <?php echo json_encode($dest_tel ?: ''); ?>,
    email: <?php echo json_encode($dest_mail ?: $admin_email); ?>,
    kilos: <?php echo json_encode((string)$total_weight); ?>,
    bultos: "1",
    tipo: "PAQ",
    referencia: "",
    observaciones: "",
    valor_asegurado: "0",
    valor_reembolso: "0"
  };
  const recogidaPrefill = {
    nombre: <?php echo json_encode(get_bloginfo('name')); ?>,
    contacto: <?php echo json_encode(get_bloginfo('name')); ?>,
    direccion: <?php echo json_encode($store_addr); ?>,
    cp: <?php echo json_encode($store_cp); ?>,
    ciudad: <?php echo json_encode($store_city); ?>,
    pais: <?php echo json_encode($store_pais); ?>,
    telefono: <?php echo json_encode($store_tel); ?>,
    email: <?php echo json_encode($admin_email); ?>,
    horario_desde: "09:00",
    horario_hasta: "19:00",
    fecha_recogida: (new Date()).toISOString().slice(0,10),
    observaciones: ""
  };

  // === 1) Solicitar servicios RapidExpress ===
$.ajax({
  type: "POST",
  url: ajaxURL,
  data: { function: "solicitarServiciosRapid" },
  success: function (resp) {
    console.log("Respuesta cruda del servidor:", resp);
    try {
      let data = JSON.parse(resp);
      console.log("Respuesta interpretada:", data);
      let servicios = [];
      if (Array.isArray(data.servicios)) {
        servicios = data.servicios;
      } else if (typeof data.servicios === "object") {
        servicios = Object.values(data.servicios);
      }
      if (servicios.length > 0) {
        $("#rapid_producto").html('<option value="">Selecciona el servicio</option>');
        servicios.forEach(function (val) {
          if (val && val.id && val.nombre) {
            $("#rapid_producto").append(
              `<option value="${val.id}" data-tipo="${(val.tipo ? val.tipo.toUpperCase() : "NAL")}">${val.nombre}</option>`
            );
          }
        });
        if (!$("#obtenerAlbaran").length) {
          $("#rapid_producto").prop("disabled", false);
        }
      } else {
        console.warn("No se encontraron servicios en la respuesta:", data);
        $("#rapid_producto").html("<option>Error al cargar servicios</option>");
      }
    } catch (e) {
      console.error("Respuesta no válida:", resp);
      $("#rapid_producto").html("<option>Error de formato en respuesta</option>");
    }
  },
  error: function (xhr, status, error) {
    console.error("Error AJAX:", error);
    $("#rapid_producto").html("<option>Error en conexión AJAX</option>");
  },
});

  // === 2) Generar envío RapidExpress ===
$("#rapid_generar_envio").on("click", function (e) {
  e.preventDefault();

  const orderId     = $("#post_ID").val();
  const producto    = $("#rapid_producto").val();
  if (!producto) { alert("Selecciona un servicio de Rapid Express."); return; }
  if (!destinoPrefill.kilos || Number(destinoPrefill.kilos) <= 0) destinoPrefill.kilos = "0.1";
  if (!destinoPrefill.bultos || Number(destinoPrefill.bultos) < 1) destinoPrefill.bultos = "1";
  destinoPrefill.tipo = "PAQ"; // o "DOC" si aplica
  $("#rapid_resultado").text("Enviando solicitud...");
  $.ajax({
    type: "POST",
    url: ajaxURL,
    dataType: "json",
    data: {
      function: "generarEnvioRapid",
      orderId: orderId,
      producto: producto,
      destino: JSON.stringify(destinoPrefill),
      recogida: JSON.stringify(recogidaPrefill)
    },
    success: function (resp) {
      console.log("generarEnvioRapid ->", resp);
      if (resp && resp.result === 200) {
        $("#rapid_resultado").html("✅ Envío generado.<br>Pedido: " + resp.pedido + "<br>Albarán: " + resp.albaran);
        location.reload();
      } else {
        $("#rapid_resultado").html("❌ Error: " + (resp && resp.error ? JSON.stringify(resp.error) : "Respuesta inválida del servidor."));
      }
    },
    error: function (xhr, s, err) {
      console.error("AJAX error:", err, xhr.responseText);
      $("#rapid_resultado").html("❌ Error de conexión: " + err);
    }
  });
});


  // === 3) Descargar albarán ===
$('#obtenerAlbaran').on('click', function(e){
  e.preventDefault();
  $.ajax({
    type: "POST",
    url: ajaxURL,
    data: { function: 'obtenerAlbaran', orderId: orderId },
    success: function(success){
      // el PHP responde el hash md5 (32 chars) cuando guarda el PDF
      if (typeof success === 'string' && /^[a-f0-9]{32}$/i.test(success.trim())) {
        window.open('<?php echo esc_js(plugins_url('albaranes/', __FILE__)); ?>' + success.trim() + '.pdf', '_blank');
      } else {
        console.log('obtenerAlbaran ->', success);
        alert('No se pudo obtener el albarán.');
      }
    },
    error: function(xhr, s, err){
      console.error("AJAX error:", err, xhr.responseText);
      alert('Error de conexión al obtener albarán.');
    }
  });
});
});
</script>
        <?php
    }
    public function enqueue_admin_scripts() {
        wp_enqueue_script('jquery');
    }
}
new Rapidexpress_Plugin();
